//
//  RTBGameDAO.h
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 3/11/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RTBGame.h"
#import <sqlite3.h>

@interface RTBGameDAO : NSObject {
    sqlite3 *db;
}


- (NSString *) getDbURL;

- (NSMutableArray *) getFinishedGames;      //SELECT
- (NSMutableArray *) getSavedGames;
- (RTBGame *) getCurrentGame;               //SELECT

- (long) createGame: (RTBGame *)game;  //INSERT
- (void) saveCurrentGame: (RTBGame *) game; //UPDATE
- (void) deleteGame: (RTBGame *) game; //UPDATE



@end
